/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import model.Block;
import model.BreadcrumbItem;
import model.Chapter;
import model.Page;
import model.SidebarNavItem;

public class JsonDataManagerExample {
    private static final String FILE_PATH = "data/example_chapter.json";

    public static void main(String[] args) {
        System.out.println("Erstelle Java-Objekte...");
        Chapter exampleChapter = JsonDataManagerExample.createExampleChapter();
        System.out.println("Java-Objekt erstellt: " + String.valueOf(exampleChapter));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        System.out.println("\nSpeichere Objekt in Datei: data/example_chapter.json...");
        JsonDataManagerExample.saveChapterToFile(exampleChapter, FILE_PATH, gson);
        System.out.println("Lade Objekt aus Datei: data/example_chapter.json...");
        Chapter loadedChapter = JsonDataManagerExample.loadChapterFromFile(FILE_PATH, gson);
        if (loadedChapter != null) {
            System.out.println("Objekt erfolgreich geladen: " + String.valueOf(loadedChapter));
            System.out.println("\n\u00dcberpr\u00fcfung der geladenen Daten:");
            System.out.println("Chapter Titel: " + loadedChapter.getChapterTitle());
            if (loadedChapter.getPages() != null && !loadedChapter.getPages().isEmpty()) {
                Block secondBlock;
                Page firstPage = loadedChapter.getPages().get(0);
                System.out.println("Erste Seite Titel: " + firstPage.getPageTitle());
                if (firstPage.getBlocks() != null && firstPage.getBlocks().size() > 1 && (secondBlock = firstPage.getBlocks().get(1)).getData().containsKey("code")) {
                    System.out.println("Code des zweiten Blocks (aus geladener Datei):");
                    System.out.println(secondBlock.getData().get("code"));
                }
            }
        } else {
            System.out.println("Fehler beim Laden des Objekts aus der Datei.");
        }
    }

    private static Chapter createExampleChapter() {
        ArrayList<BreadcrumbItem> breadcrumbs = new ArrayList<BreadcrumbItem>();
        breadcrumbs.add(new BreadcrumbItem("Startseite", "../index.html"));
        breadcrumbs.add(new BreadcrumbItem("Praktische Informatik", "../praktische-informatik.html"));
        ArrayList<SidebarNavItem> sidebarItems = new ArrayList<SidebarNavItem>();
        sidebarItems.add(new SidebarNavItem("1. Einf\u00fchrung", "#einfuehrung", false));
        sidebarItems.add(new SidebarNavItem("1.1 Grundkonzepte", "#grundkonzepte", true));
        HashMap<String, Object> textBlockData = new HashMap<String, Object>();
        textBlockData.put("content", "<p>Dies ist ein <b>fetter</b> Beispieltext.</p><p>Ein weiterer Absatz.</p>");
        HashMap<String, Object> codeBlockData = new HashMap<String, Object>();
        codeBlockData.put("header", "Hallo Welt in Java");
        codeBlockData.put("language", "java");
        codeBlockData.put("code", "public class Main {\n    public static void main(String[] args) {\n        System.out.println(\"Hello, World!\");\n    }\n}");
        ArrayList<Block> pageBlocks = new ArrayList<Block>();
        pageBlocks.add(new Block("text-block", textBlockData));
        pageBlocks.add(new Block("code-block", codeBlockData));
        ArrayList<Page> chapterPages = new ArrayList<Page>();
        Page examplePage = new Page("Beispielseite Programmierung", "beispielseite", breadcrumbs, sidebarItems, pageBlocks);
        chapterPages.add(examplePage);
        return new Chapter("Beispiel Kapitel", "beispiel-kapitel", "Dies ist ein Beispielkapitel f\u00fcr Tests.", chapterPages);
    }

    public static void saveChapterToFile(Chapter chapter, String filePath, Gson gson) {
        File file = new File(filePath);
        file.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(filePath);){
                gson.toJson((Object)chapter, (Appendable)writer);
                System.out.println("Daten erfolgreich gespeichert.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Fehler beim Schreiben der Datei: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static Chapter loadChapterFromFile(String filePath, Gson gson) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileReader reader = new FileReader(filePath);){
                Chapter chapter = gson.fromJson((Reader)reader, Chapter.class);
                System.out.println("Daten erfolgreich geladen.");
                return chapter;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Fehler beim Lesen der Datei: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (JsonParseException e) {
            System.err.println("Fehler beim Parsen der JSON-Daten: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

